#! /usr/bin/env bash

function cleanup() {
  echo 'restoring mouse cursor' 
  killall xbanish

  echo 'restoring desktop monitor'
  /usr/local/bin/unprojectorify.sh

  echo 'restoring screen blank and suspend on idle'
  gsettings set org.gnome.desktop.session idle-delay 120
  gsettings set org.gnome.settings-daemon.plugins.power sleep-inactive-ac-type 'suspend'
}

trap cleanup SIGINT

export DISPLAY=:1

echo 'use HDMI display only and send audio there'
/usr/local/bin/projectorify.sh 

echo 'disabling screen blanking and suspend on idle'
gsettings set org.gnome.desktop.session idle-delay 0
gsettings set org.gnome.settings-daemon.plugins.power sleep-inactive-ac-type 'nothing'

echo 'hiding mouse cursor'
xbanish -a &

echo 'launching OpenSpace'
cd ~/Sites/src/OpenSpace
./bin/OpenSpace -b -p './user/data/profiles/remote projection.profile' -c ./user/config/uhd-projection.json 

cleanup