#! /usr/bin/env bash
# adapted from https://docs.zfsbootmenu.org/en/v2.3.x/guides/ubuntu/uefi.html
# script is not meant to be run non-interactively. read and understand before executing

sudo -i

source /etc/os-release
export ID

export POOL_DEVICE="/dev/nvme1n1p3"

zpool create -f -o ashift=12 \
 -O compression=zstd \
 -O acltype=posixacl \
 -O xattr=sa \
 -O relatime=on \
 -o autotrim=on \
 -o compatibility=openzfs-2.1-linux \
 -m none zroot "$POOL_DEVICE"

zfs create -o mountpoint=none zroot/ROOT
zfs create -o mountpoint=/ -o canmount=noauto zroot/ROOT/${ID}
zfs create -o mountpoint=/home zroot/home

zpool set bootfs=zroot/ROOT/${ID} zroot

zpool export zroot
zpool import -N -R /mnt/shredder-zfs zroot

zfs mount zroot/ROOT/${ID}
zfs mount zroot/home

udevadm trigger

rsync -avAHXx --numeric-ids --exclude='/home' --exclude='/timeshift' /mnt/shredder/ /mnt/shredder-zfs/
rsync -av --numeric-ids /mnt/shredder/home/ /mnt/shredder-zfs/home/
umount /mnt/shredder

mount -t proc /proc /mnt/shredder-zfs/proc
mount -t sysfs /sys /mnt/shredder-zfs/sys
mount -B /dev /mnt/shredder-zfs/dev
mount -t devpts pts /mnt/shredder-zfs/dev/pts
mount /dev/nvme1n1p1 /mnt/shredder-zfs/boot/efi
chroot /mnt/shredder-zfs /bin/bash



### now in zroot



source /etc/os-release
export ID

apt update
apt remove kernelstub
apt-mark hold kernelstub grub-common grub-pc grub-efi-amd64-signed grub-efi-amd64:i386 grub-efi-amd64-bin grub-efi-ia32 lilo
apt install zfs-initramfs zfsutils-linux zfs-dkms
# next time you have a kernel update, you'll likely have to upgrade with flags since we've held back dependencies
sudo apt upgrade --with-new-pkgs linux-generic

systemctl enable zfs.target
systemctl enable zfs-import-cache
systemctl enable zfs-mount
systemctl enable zfs-import.target

echo "UMASK=0077" > /etc/initramfs-tools/conf.d/umask.conf

update-initramfs -c -k all

zfs set org.zfsbootmenu:commandline="systemd.show_status=false splash loglevel=0 quiet" zroot/ROOT

# assumes your ESP is mounted at /boot/efi

# removing kernelstub entries and boot files
rm /boot/efi/loader/entries/Pop*
rm -r /boot/efi/EFI/Pop*

# copy zbm boot files
wget -qO- https://get.zfsboot.menu/components/release | tar xvz -C /boot/efi/EFI
# ignore ownership errors
mv /boot/efi/EFI/zfsbootmenu-release-x86_64-v* /boot/efi/EFI/zbm

# add entries
cat << EOF > /boot/efi/loader/entries/pop.conf
title Pop!_OS
linux /EFI/zbm/vmlinuz-bootmenu
initrd /EFI/zbm/initramfs-bootmenu.img
options zbm.skip systemd.show_status=false splash loglevel=0 quiet
EOF

cat << EOF > /boot/efi/loader/entries/zbm.conf
title ZFSBootMenu
linux /EFI/zbm/vmlinuz-bootmenu
initrd /EFI/zbm/initramfs-bootmenu.img
options zbm.show
EOF

echo 'default pop' > /boot/efi/loader/loader.conf

exit



### out of zroot



umount -n -R /mnt/shredder-zfs
zpool export zroot

# reboot into system
systemctl reboot