#! /usr/bin/env bash
# adapted from https://docs.zfsbootmenu.org/en/v2.3.x/guides/ubuntu/uefi.html

source /etc/os-release
export ID

export POOL_DISK="/dev/sdg"
export POOL_PART="3"
export POOL_DEVICE="${POOL_DISK}${POOL_PART}"

echo 'passphrase' > /etc/zfs/zroot.key
chmod 000 /etc/zfs/zroot.key

zpool create -f -o ashift=12 \
 -O compression=zstd \
 -O acltype=posixacl \
 -O xattr=sa \
 -O relatime=on \
 -O encryption=aes-256-gcm \
 -O keylocation=file:///etc/zfs/zroot.key \
 -O keyformat=passphrase \
 -o autotrim=on \
 -o compatibility=openzfs-2.1-linux \
 -m none zroot "$POOL_DEVICE"

zfs create -o mountpoint=none zroot/ROOT
zfs create -o mountpoint=/ -o canmount=noauto zroot/ROOT/${ID}
zfs create -o mountpoint=/home zroot/home

zpool set bootfs=zroot/ROOT/${ID} zroot

zpool export zroot
zpool import -N -R /mnt zroot
zfs load-key -L prompt zroot

zfs mount zroot/ROOT/${ID}
zfs mount zroot/home

udevadm trigger

rsync -avAHXx --numeric-ids --exclude='/home' --exclude='/timeshift' /media/curiouser/5b30118c-3837-4895-9c60-70ea27dd36d9/ mnt/
rsync -av --numeric-ids /media/curiouser/5b30118c-3837-4895-9c60-70ea27dd36d9/home/ mnt/home/

mount -t proc proc mnt/proc
mount -t sysfs sys mnt/sys
mount -B /dev mnt/dev
mount -t devpts pts mnt/dev/pts
chroot mnt /bin/bash

source /etc/os-release
export ID

apt update
apt install zfs-initramfs zfsutils-linux

systemctl enable zfs.target
systemctl enable zfs-import-cache
systemctl enable zfs-mount
systemctl enable zfs-import.target

echo "UMASK=0077" > /etc/initramfs-tools/conf.d/umask.conf

update-initramfs -c -k all

zfs set org.zfsbootmenu:commandline="systemd.show_status=false splash loglevel=0 quiet resume=UUID=9a4e4168-0964-4895-8d40-0e1ee0bf5d9a" zroot/ROOT
zfs set org.zfsbootmenu:keysource="zroot/ROOT/${ID}" zroot

exit

umount -n -R /mnt
zpool export zroot
# reboot into system

sudo -i
apt remove kernelstub
cat <<EOF > /etc/apt/preferences.d/blacklist-kernelstub
Package: kernelstub 
Pin: release *
Pin-Priority: -1
EOF
