local DOMAIN = Lua.assert(ENV_SNIKKET_DOMAIN, "Please set the SNIKKET_DOMAIN environment variable")

modules_enabled: append {
  "privilege";
}

local _privileges = {
    roster = "both";
    message = "outgoing";
    iq = {
      ["http://jabber.org/protocol/pubsub"] = "both";
      ["http://jabber.org/protocol/pubsub#owner"] = "set";
    };
}

VirtualHost (DOMAIN)
  -- for roster sync and 'legacy carbons'
  privileged_entities = {
    ["mattermost.domain.tld"] = _privileges,
    ["whatsapp.domain.tld"] = _privileges,
    ["matrix.domain.tld"] = _privileges,
    ["telegram.domain.tld"] = _privileges,
    ["signal.domain.tld"] = _privileges,
  }

Component ("share."..DOMAIN) "http_file_share"
  server_user_role = "prosody:registered"

Component ("mattermost."..DOMAIN)
  component_secret = "redacted"
  modules_enabled = {"privilege"}

Component ("whatsapp."..DOMAIN)
  component_secret = "redacted"
  modules_enabled = {"privilege"}

Component ("matrix."..DOMAIN)
  component_secret = "redacted"
  modules_enabled = {"privilege"}

Component ("telegram."..DOMAIN)
  component_secret = "redacted"
  modules_enabled = {"privilege"}

Component ("signal."..DOMAIN)
  component_secret = "redacted"
  modules_enabled = {"privilege"}