#!/usr/bin/env node

const currentYear = new Date().getFullYear();

const adjustments = {
  exteriorColor: {
    black: 1000,
    blue: -500,
    burgundy: 500,
    charcoal: 500,
    deepBlue: 250,
    silver: 0,
    white: 250,
  },
  interiorColor: {
    dark: 0,
    light: 500,
    mixed: -250,
  },
  miles: [ 5000, 150 ],
  year: [ 1, 750 ],
};

const benchmark = {
  exteriorColor: 'silver',
  interiorColor: 'dark',
  miles: 100000,
  price: 10357,
  year: 2016,
};

const [ price, year, miles, exteriorColor, interiorColor ] = process.argv.slice(2);
// args list length
if (process.argv.slice(2).length !== 5) {
  throw new Error(`Expected exactly 5 args, found ${process.argv.slice(2).length}`);
}
// 1st 3 args should be numbers
[ price, year, miles ].forEach((number, i) => {
  if (isNaN(number)) {
    throw new Error(`arg #${number + 1} should be number`);
  }
});
// 4th arg should be enumerated
if (!Object.keys(adjustments.exteriorColor).includes(exteriorColor)) {
  throw new Error(`4th arg (exteriorColor) must be in list ${Object.keys(adjustments.exteriorColor).join(', ')}`);
}
// 5th arg should be enumerated
if (!Object.keys(adjustments.interiorColor).includes(interiorColor)) {
  throw new Error(`5th arg (interiorColor) must be in list ${Object.keys(adjustments.interiorColor).join(', ')}`);
}

const benchYearsOld = currentYear - benchmark.year;
const yearsOld = currentYear - Number(year);

function calcAdjustment (benchValue, value, [ quantifier, valueAdjustment ] = [ 1, 1 ]) {
  return (Number(value) - benchValue) / quantifier * valueAdjustment;
}

let adjustedPrice = Number(price);
adjustedPrice += calcAdjustment(benchmark.miles, miles, adjustments.miles);
adjustedPrice += calcAdjustment(benchYearsOld, yearsOld, adjustments.year);
adjustedPrice += calcAdjustment(0, adjustments.exteriorColor[exteriorColor]);
adjustedPrice += calcAdjustment(0, adjustments.interiorColor[interiorColor]);

console.log(adjustedPrice);
