#! /usr/bin/env bash

# If the Pop! installer won't boot due to dGPU failure, remove the SATA SSD/HDD from the MacBook and install Pop! to it using a computer that will boot the installer

# With Pop! installed and running as root
# disable AMD gpu drivers
cat << EOF > /etc/modprobe.d/blacklist-amd-dgpu.conf
blacklist radeon
blacklist amdgpu
EOF

# install package updates
apt update
apt upgrade

# install Wi-Fi drivers
apt install firmware-b43-installer

# install fan controls to keep them from running max speed
apt install mbpfan

# if kernel ramdisk wasn't updated, update that now
update-initramfs -c -k all

# if you need to reinstall the SATA disk, do that and boot up.