// open the likes/comments activity panel prior to running this in a web console.
// this will insert thumbs just above the album photos

(() => {
  // cleanup and init
  try {
    document.querySelector('#virtual-timeline').parentNode.removeChild(document.querySelector('#selects'))
  } catch {}
  document.querySelector('#virtual-timeline').insertAdjacentHTML('beforebegin', '<div class="flex flex-wrap" id="selects"></div>')
  
  const commentCountMap = new Map()
  const commentThumbs = Array.from(document.querySelectorAll('#activity-panel img[alt*=commented]'))
  const likeCountMap = new Map()
  const likeThumbs = Array.from(document.querySelectorAll('#activity-panel img[alt*=liked]'))
  const selects = document.querySelector('#selects')
  const srcSet = new Set()

  // count comments per img
  commentThumbs.forEach(img => {
    const count = commentCountMap.get(img.src) || 0
    commentCountMap.set(img.src, count + 1)
    srcSet.add(img.src)
  })
  // count likes per img
  likeThumbs.forEach(img => {
    const count = likeCountMap.get(img.src) || 0
    likeCountMap.set(img.src, count + 1)
    srcSet.add(img.src)
  })

  // map each img src to a tuple [ src, commentCount, likeCount ]
  Array.from(srcSet)
    .map(src => [
      src,
      commentCountMap.get(src) || 0,
      likeCountMap.get(src) || 0,
    ])
    // sort on likes, then comments DESC
    .sort((a, b) => {
      if (a[2] > b[2]) return -1
      else if (a[2] < b[2]) return 1
      else {
        if (a[1] > b[1]) return -1
        else if (a[1] < b[1]) return 1
      }
      return 0
    })
    // insert thumb into DOM with counts
    .forEach(([ src, comments, likes ]) => {
      selects.insertAdjacentHTML('beforeend', `<div style="flex: 0 0 50%;">
      <img src="${src}" />
      <span>${likes} likes</span>
      <span>${comments} comments</span>
    </div>`)
    })
})()