#!/bin/bash

echo 'restoring text-scaling to 133%'
gsettings set org.gnome.desktop.interface text-scaling-factor 1.33

echo 'restoring auto suspend on AC power'
gsettings set org.gnome.settings-daemon.plugins.power sleep-inactive-ac-type 'suspend'

echo 're-enabling suspend-then-hibernate'
test -h /etc/systemd/system/systemd-suspend.service || sudo ln -s /usr/lib/systemd/system/systemd-suspend-then-hibernate.service /etc/systemd/system/systemd-suspend.service

# Force move backup mapping file to original
#if [ -f /usr/share/X11/xkb/symbols/pc.bak ]; then
#  echo "Restoring Super and Control behaviour ..."
#  sudo mv -f /usr/share/X11/xkb/symbols/pc.bak /usr/share/X11/xkb/symbols/pc
#fi

# reload keyboard config
#echo 'reloading keyboard'
#setxkbmap -layout us

echo 'setting power settings'
# use dGPU for compute only
# system76-power graphics | grep integrated || system76-power graphics integrated 
# set battery preserving charge thresholds
system76-power charge-thresholds | grep balanced || sudo system76-power charge-thresholds --profile balanced
# set power profile
system76-power profile | grep Balanced || system76-power profile balanced

echo 'unsetting fan speed floor'
fanspeed.sh 0