#!/bin/bash

# scale text up to match 15" MacBook Pro
gsettings set org.gnome.desktop.interface text-scaling-factor 1.33

# restore default keyboard for built-in
## Force move backup mapping file to original
if [ -f /usr/share/X11/xkb/symbols/pc.bak ]; then
  echo "Restoring Super and Control behaviour ..."
  sudo mv -f /usr/share/X11/xkb/symbols/pc.bak /usr/share/X11/xkb/symbols/pc
fi

## reload keyboard config
echo 'reloading keyboard'
setxkbmap -layout us

echo 'setting power settings'
# use dGPU for compute only
system76-power graphics compute
# set balanced charge thresholds
sudo system76-power charge-thresholds --profile balanced
# set power profile
system76-power profile balanced