#!/bin/bash

# restore default text size since our external display is already 200% scaled
gsettings set org.gnome.desktop.interface text-scaling-factor 1.0

# configure keys for Apple Wired keyboard
## Backup curent /usr/share/X11/xkb/symbols/pc
if [ ! -f /usr/share/X11/xkb/symbols/pc.bak ]; then
  echo "Backing up /usr/share/X11/xkb/symbols/pc..."
  sudo cp /usr/share/X11/xkb/symbols/pc /usr/share/X11/xkb/symbols/pc.bak
fi

## Flip Super and Control keys
echo "Flipping Super and Control keys..."
## Use original (backed up) file if exists
if [ -f /usr/share/X11/xkb/symbols/pc.bak ]; then
  sudo cp -f /usr/share/X11/xkb/symbols/pc.bak /usr/share/X11/xkb/symbols/pc
fi
sudo sed -i 's/<LCTL> {\t\[ Control_L/<LCTL> {\t\[ Super_L/' /usr/share/X11/xkb/symbols/pc
sudo sed -i 's/<LWIN> {\t\[ Super_L/<LWIN> {\t\[ Control_L/' /usr/share/X11/xkb/symbols/pc
sudo sed -i 's/<RCTL> {\t\[ Control_R/<RCTL> {\t\[ Super_R/' /usr/share/X11/xkb/symbols/pc
sudo sed -i 's/<RWIN> {\t\[ Super_R/<RWIN> {\t\[ Control_R/' /usr/share/X11/xkb/symbols/pc

## reload keyboard config
setxkbmap -layout us
echo 'keyboard updated'

# use dGPU for graphics
echo 'setting power settings'
system76-power graphics nvidia
# set battery preserving charge thresholds
sudo system76-power charge-thresholds --profile max_lifespan
# set power profile to performance
system76-power profile performance
