#! /usr/bin/env bash

# install git
apt update
apt install -y git

# download and prepare Iris for build
git clone --depth=1 https://github.com/jaedb/Iris.git
cd Iris

# login, build and push
docker login
docker buildx build --platform linux/arm64 -t curiousercreative/iris:latest --push .

# slim the PIP packages, build and push a slim tag
cat << EOF > docker/requirements.txt
Mopidy-Local
Mopidy-Mpd
EOF
docker buildx build --platform linux/arm64 -t curiousercreative/iris:slim --push .