// This script is intended to be run from a web console. It must be run from the correct webpage.
// Step 1: Fill out this and search https://process.dmv.ny.gov/FacilityLookup/
// Step 2: Select your vehicle type, etc until you receive results
// Step 3: Edit the countResults variable below to the actual number
// Step 4: Inject jQuery into the webpage by copying the commented code below into the web console
// var jq = document.createElement('script');jq.src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js";document.getElementsByTagName('head')[0].appendChild(jq);

// Step 5: Copy and paste the below into your web console and run it. When the searching is finished, you should receive an array of matches logged to console.

// modify this value to be the total # of results
countResults = 406;
// fill this with shop names to search for, perhaps from Yelp or another search engine
nameSearch = [];

// leave empty, this will be populated with search matches
matches = [];
// leave empty, used for acting on the completion of all AJAX requests
promises = [];
// leave empty, will fill with NYS results
results = [];
// leave as is, maps the text/html response TDs to an object with the correct key
tdMap = [
  'number',
  'name',
  'address',
  'borough',
  'zip',
  'county'
];

// make as many AJAX requests as necessary (due to paged results)
for (var i = 1; i < resultCount; i += 20) {
  // add each of these fetch calls to our promises array
  promises.push(fetch(`https://process.dmv.ny.gov/FacilityLookup/vsiqSearchLocationResults.cfm?selText=Vehicle%20Category:%20%3Cspan%20class=%27boldRed%27%3ERegistered%20Weight%20of%208,500%20lbs.%20or%20less.%20%3C/span%3E%20Fuel%20Type:%20%3Cspan%20class=%27boldRed%27%3EDiesel%3C/span%3E&StartRow=${i}&facsort=none&facnamesort=ASC&facstreetsort=none&faccitysort=none&faczipsort=none&PageNum=0&COUNTYRES=KING&COUNTYRES_DESC=Kings&ZIP=&inspection=%27SAF%27&insp_types=FLOW4&paging=1&sid=0.5118711909866791`)
    .then(function (response) {
      // fetch response.body is a stream, this will decode into text
      response.text().then(function (text) {
        // take our node collection and get the results table, then find only the rows that contain results data...
        $($(text)[2]).find('tr:nth-child(n+7):not(:last-child)').each(function (i, tr) {
          var result = {};

          // map each table cell into an object key
          $(tr).find('td').each(function (i, td) {
            // use of tdMap to map each td to the correct key
            result[tdMap[i]] = $.trim($(td).text().toLowerCase());
          });          

          results.push(result);
        });
      });
    })
  );
}

// When all of the fetch requests have received responses and are processed...
Promise.all(promises).then(function () {
  // perform a name search for each name we're interested in
  nameSearch.forEach(function (name) {
    var match = results.find(function (res) {
      // we're doing a contains search
      return res.name.search(name) > -1;
    });

    if (match) {
      // add our match
      matches.push(match);
      // remove it from our results array so it doesn't get returned more than once
      results.splice(results.indexOf(match), 1);
    }
  });

  console.log(matches);
});