const glob = require("glob");
const { execSync } = require('child_process');

console.log('building list of files');

const opts = { absolute: true };
var files = glob.sync("**/*.ts", opts).concat(glob.sync("**/*.tsx", opts)).filter(f => f.indexOf('node_modules') < 0);

console.log(`found ${files.length} files`);

files.forEach(f => {
  const newName = f.replace(/\.ts(x)?$/, '.js$1');
  console.log(`renaming ${f} to ${newName}`);
  execSync(`git mv ${f} ${f.replace(/\.ts(x)?$/, '.js$1')}`);
});
