#!/usr/bin/env bash
# as superuser
sudo su

# write a systemd service file to set graphics power after system76-power service starts
cat <<EOF > /etc/systemd/system/system76-power-graphics-power-default.service
[Unit]
Description=Set the graphics power to off for integrated graphics during startup.
After=com.system76.PowerDaemon.service

[Service]
Type=simple
ExecStart=/bin/bash -c '[[ $(system76-power graphics) == 'integrated' ]] && system76-power graphics power off' 

[Install]
WantedBy=default.target
EOF

# enable our new service
systemctl enable system76-power-graphics-power-default

exit

exit 0