#! /bin/bash
askYesNo() {
  local answer=
  while [ "$answer" != "y" ] && [ "$answer" != "n" ]; do
    read -e -n 1 -p "$1 (y/n) " answer
  done

  if [ "$answer" != "y" ]; then
    return 1
  fi
}

transcode() {
  for i in *.mov; do
    if [ -e "$i" ]; then
      ffmpeg -i "$i" -c:v copy -c:a pcm_s16le "${i%.mov}-pcm.mov"
    fi
  done
  
  for i in *.mp4; do
    if [ -e "$i" ]; then
      ffmpeg -i "$i" -c:v copy -c:a pcm_s16le "${i%.mp4}-pcm.mov"
    fi
  done 
}

cd "$1"
ls -1 *.mov 2> /dev/null
ls -1 *.mp4 2> /dev/null

if askYesNo "Transcode AAC audio to Linear PCM audio and rewrap as .mov for the above files?"; then
  transcode
fi