#! /bin/bash
askYesNo() {
  local answer=
  while [ "$answer" != "y" ] && [ "$answer" != "n" ]; do
    read -e -n 1 -p "$1 (y/n) " answer
  done

  if [ "$answer" != "y" ]; then
    return 1
  fi
}

cd "$1"
ls -1 *.{mov,mp4}

if askYesNo "Transcode AAC audio to Linear PCM audio and rewrap as .mp4 for the above files?"; then
  for i in *.{mov,mp4}; do ffmpeg -i "$i" -c:v copy -c:a pcm_s16le "${i%.m}-pcm.mov"; done
fi