#! /usr/bin/env bash

# displays.sh single
# displays.sh stack
# displays.sh split
# displays.sh triple

case $1 in
  single)
    xrandr \
      --output DP-4 --auto --primary \
      --output HDMI-0 --off \
      --output DP-2 --off
    ;;
  stack | dual | dual-stack)
    xrandr \
      --output DP-4 --auto --pos 0x2160 --primary \
      --output HDMI-0 --auto --pos 720x0 \
      --output DP-2 --off
    ;;
  split | dual-split)
    xrandr \
      --output DP-4 --auto --pos 0x0 --primary \
      --output HDMI-0 --off \
      --output DP-2 --auto --pos 2560x0
    ;;
  triple)
    xrandr \
      --output DP-4 --auto --pos 0x2160 --primary \
      --output HDMI-0 --auto --pos 720x0 \
      --output DP-2 --auto --pos 2560x2160
    ;;
  *)
    echo 'please specify a configuration, one of: single, stack, split, triple'
    exit 1
esac
exit 0
