#! /usr/bin/env bash
# NOTE: this is not meant to be run unattended, read each line and copy and paste as necessary
# This worked for my migration from Pop!_OS 22.04 (deb based) Atom 1.63.1 installed with flatpak (user)

# First, download and install the deb package found here https://pulsar-edit.dev/download.html

# for flatpak Atom migration to Pulsar deb - copy configuration and packages
rsync -av ~/.var/app/io.atom.Atom/data/ ~/.pulsar/

# for deb Atom migration to Pulsar deb - copy configuration and packages
#rsync -av ~/.atom/ ~/.pulsar/

# fix for GPU error
cat <<EOF > ~/.local/bin/pulsar
#! /usr/bin/env bash
/usr/bin/pulsar --disable-gpu-sandbox "\$@"
EOF
chmod u+x ~/.local/bin/pulsar

# write a local user desktop file where the icon is fixed
cat <<EOF > ~/.local/share/applications/pulsar.desktop
[Desktop Entry]
Name=Pulsar
Exec=/usr/bin/pulsar %U
Terminal=false
Type=Application
Icon=/opt/Pulsar/resources/pulsar.png
StartupWMClass=Pulsar
Comment=A Community-led Hyper-Hackable Text Editor
Categories=Development;
EOF
